/**
 * Node.js 短信发送程序 - 基于企信通HTTP 1.0接口
 * 使用HTTP POST方式发送短信（UTF-8编码）
 * 文档参考：企信通大客户接口说明
 */

const http = require('http');
const querystring = require('querystring');

// ================== 配置参数（请根据实际情况修改）==================
const config = {
  userid: 'YOUR_USERID',           // 企业ID（后台：客户管理 -> 我的信息）
  account: 'YOUR_ACCOUNT',         // 短信账号
  password: 'YOUR_PASSWORD',       // 登录密码（明文）
  mobile: '13800138000',           // 接收号码，多个用英文逗号分隔
  content: '【智想云创】您的注册验证码：8899', // 短信内容，需包含签名
  sendTime: '',                    // 定时时间，格式：YYYY-MM-DD HH:mm:ss，空为立即发送
  extno: '',                       // 扩展子号（可选，需通道支持）
};

// ================== 构建POST请求数据 ==================
const postData = querystring.stringify({
  action: 'send',           // 固定值：send
  userid: config.userid,
  account: config.account,
  password: config.password,
  mobile: config.mobile,
  content: config.content,
  sendTime: config.sendTime,
  extno: config.extno,
  rt: 'json'                // 返回JSON格式（不填则默认XML）
});

// ================== HTTP请求选项 ==================
const options = {
  hostname: 'cloud.thinksms.cn',
  port: 80,
  path: '/sms.aspx',
  method: 'POST',
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded',
    'Content-Length': Buffer.byteLength(postData)
  }
};

// ================== 发送HTTP请求 ==================
const req = http.request(options, (res) => {
  let data = '';

  res.on('data', (chunk) => {
    data += chunk;
  });

  res.on('end', () => {
    try {
      const result = JSON.parse(data);

      /**
       * 返回值解析（对应文档 1.3 返回值说明）：
       *
       * ReturnStatus:   Success | Faild
       *   - Success: 请求提交成功（不代表短信送达）
       *   - Faild:   提交失败（如账号错误、内容为空等）
       * RemainPoint:    当前账户剩余短信条数（余额）
       *
       * TaskID:         本次发送任务的唯一ID，可用于查询状态报告
       *
       * SuccessCounts:  成功提交的手机号数量（如发送2个正确号码，返回2）
       */

      console.log('【短信发送响应】', result);

      /*
       * 示例成功返回：
       * {
       *   "ReturnStatus": "Success",
       *   "Message": "ok",
       *   "RemainPoint": 109346,
       *   "TaskID": 365,
       *   "SuccessCounts": 2
       * }
       */

    } catch (e) {
      console.error('解析返回结果失败:', e, data);
    }
  });
});

// 处理请求错误
req.on('error', (e) => {
  console.error('【HTTP请求错误】', e.message);
});

// 写入请求体并结束
req.write(postData);
req.end();