<?php
/**
 * 文件: get_reply.php
 * 功能: 获取上行短信（用户回复）
 * 编码: 仅此接口，与内容编码无关
 */

require_once 'SmsClient.php';

class GetReply extends SmsClient {
    
    /**
     * 获取用户上行回复
     * @param int $ownExt 是否使用自有扩展号 (0/1)
     * @return array 接口返回结果，包含回复数组
     */
    public function get($ownExt = 0) {
        $params = $this->getBaseParams('query');
        if ($ownExt) {
            $params['ownExt'] = 1;
        }
        
        return $this->sendRequest($this->replyUrl, $params);
    }
}

// 使用示例
/*
$client = new GetReply('your_userid', 'your_account', 'your_password');
$replies = $client->get();
print_r($replies);
*/