<?php
/**
 * 文件: get_reply.php
 * 功能: 获取用户上行短信回复功能
 * 编码: 此接口URL固定，与内容编码无关
 */

require_once 'sms_common.php';

/**
 * 获取用户上行短信回复
 * @param string $userid 企业ID（登录后台->客户管理->我的信息）
 * @param string $account 短信账号
 * @param string $password 登录密码
 * @param int $ownExt 是否使用自有扩展号 (0/1)
 * @return array 接口返回结果，包含回复数组
 */
function sms_get_reply($userid, $account, $password, $ownExt = 0) {
    $params = sms_get_base_params($userid, $account, $password, 'query');
    if ($ownExt) {
        $params['ownExt'] = 1;
    }
    
    $url = 'http://cloud.thinksms.cn/callApi.aspx';
    
    return sms_send_request($url, $params);
}

// --- 使用示例 ---
/*
$replies = sms_get_reply('your_userid', 'your_account', 'your_password');
print_r($replies);
*/
?>