<?php
/**
 * 文件: get_balance.phpget_balance.php
 * 功能: 查询账户余额和已发送量功能
 * 编码: 支持UTF-8和GBK，默认UTF-8
 */

require_once 'sms_common.php';

/**
 * 查询账户余额和已发送量
 * @param string $userid 企业ID（登录后台->客户管理->我的信息）
 * @param string $account 短信账号
 * @param string $password 登录密码
 * @param bool $useGbk 是否使用GBK编码 (默认false，使用UTF-8)
 * @return array 接口返回结果
 */
function sms_get_balance($userid, $account, $password, $useGbk = false) {
    $params = sms_get_base_params($userid, $account, $password, 'overage');
    
    $baseUrl = $useGbk ? 'http://cloud.thinksms.cn/smsGBK.aspx' : 'http://cloud.thinksms.cn/sms.aspx';
    
    return sms_send_request($baseUrl, $params);
}

// --- 使用示例 ---
/*
$balance = sms_get_balance('your_userid', 'your_account', 'your_password');
print_r($balance);
*/
?>