<?php
/**
 * 短信发送接口调用示例
 */

// 配置参数
$userid = '你的企业ID';		//（登录后台->客户管理->我的信息）查询企业ID
$account = '你的短信账号';
$password = '你的密码';
$mobile = '13800138000,13800138001'; 		// 接收号码，多个用英文,逗号隔开
$content = '【智想云创】您的注册验证码：8899'; 	// 短信内容，开头必须带签名
$sendUrl = 'http://cloud.thinksms.cn/sms.aspx'; 		// UTF-8编码接口地址
//$sendUrl = 'http://cloud.thinksms.cn/smsGBK.aspx'; 	// GBK编码接口地址

// 构建请求参数
$data = [
    'action' => 'send',
    'rt' => 'json', 			// 返回JSON格式
    'userid' => $userid,
    'account' => $account,
    'password' => $password,
    'mobile' => $mobile,
    'content' => $content,
//  'sendTime' => $sendTime,	//定时发送，可为空或具体时间（2010-10-24 09:08:10），不能传0
    'extno' => '' // 扩展子号，如不支持请留空
];

// 发送HTTP POST请求
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $sendUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30); // 30秒超时

$response = curl_exec($ch);
curl_close($ch);

// echo $response;		// 输出原始返回值

// 简单解析返回值
$result = json_decode($response, true);
$status = $result['ReturnStatus'] ?? '';
if ($status === 'Success') {
    echo "发送成功";
} else {
    echo "发送失败";
}

/*
返回值解析说明：
{
    "ReturnStatus": "Success",       // 返回状态值：Success 成功, Faild 失败
    "Message": "ok",                 // 返回信息：ok-提交成功，其他错误信息见文档
    "RemainPoint": 109346,           // 返回余额
    "TaskID": 365,                   // 返回本次任务的序列ID
    "SuccessCounts": 2               // 提交成功短信数
}

接入注意事项：（常见问题）
1.内容乱码						-->> 编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，如两个提交入口均乱码，内容进行UTF-8编码。
2.提示短信必须带【】格式签名	-->> 提交入口不正确导致乱码，系统识别不到【】签名；或短信内容未携带前缀签名；
3.返回错误0						-->> 定时短信sendtime格式错误，sendtime可为空或具体时间，不能传0
4.程序异常，请重试或联系客服！从字符串转换日期和/或时间时，转换失败。-->> 定时短信sendtime格式错误，sendtime可为空或具体时间，不能传0

*/
?>