<?php
/**
 * 短信发送功能示例
 * 
 * 该脚本演示如何使用企信通大客户HTTP2.0接口发送短信。
 * 根据文档，需要构造包含必要参数（userid, timestamp, sign, mobile, content等）的POST请求，
 * 并使用MD5加密生成签名(sign)。
 * 
 * 注意：请将 YOUR_USERID, YOUR_USERNAME, YOUR_PASSWORD 替换为实际的账户信息。
 *       发送内容(content)必须包含短信签名（如【智想云创】）。
 */

// ------------------------ 配置区域 ------------------------

$userid = 'YOUR_USERID';        // 企业ID（登陆后台-客户管理-我的信息）
$username = 'YOUR_USERNAME';    // 账号
$password = 'YOUR_PASSWORD';    // 密码

// 短信接收号码（多个号码用英文,逗号分隔）
$mobile = '13800138000'; // 请替换为实际手机号

// 短信内容（必须包含签名）
$content = '【智想云创】您的注册验证码是：123456'; // 请替换为实际内容
// ---------------------------------------------------------

// 获取当前时间戳 (格式: YYYYMMDDHHMMSS)
$timestamp = date('YmdHis');

// 根据文档说明，生成接口密钥 sign
// sign = MD5(账号 + 密码 + 时间戳)，32位小写
$signString = $username . $password . $timestamp;
$sign = md5($signString);

// 准备POST请求数据
$postData = [
    'userid'    => $userid,
    'timestamp' => $timestamp,
    'sign'      => $sign,
    'mobile'    => $mobile,
    'content'   => $content,
    'action'    => 'send',
    'rt'        => 'json' // 指定返回JSON格式
];

// 使用UTF-8编码的接口地址
$url = 'http://cloud.thinksms.cn/v2sms.aspx';
//$url = 'http://cloud.thinksms.cn/v2smsGBK.aspx';	//GBK编码提交入口

// 初始化cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

// 执行请求并获取响应
$response = curl_exec($ch);

// 输出原始返回值
echo $response;

// 关闭cURL句柄
curl_close($ch);
?>