import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * 上行短信接口（用户回复）
 * 对应文档：第五章 上行接口
 * 注意：相同的上行消息只能获取一次（获取后即删除）
 */
public class ReceiveSms {

    private static final String RECEIVE_URL = "http://cloud.thinksms.com/callApi.aspx";
    private static final String USER_ID = "your_user_id";   //（登录后台->客户管理->我的信息）查询企业ID
    private static final String ACCOUNT = "your_account";   // 替换为实际值
    private static final String PASSWORD = "your_password"; // 替换为实际值

    public static void main(String[] args) {
        String result = fetchReceiveMessages();
        System.out.println("接口返回结果: " + result);

        /*
         * ==================== 返回值解析 ====================
         *
         * 成功示例：
         * {
         *   "ReturnStatus":"Success",
         *   "Message":"OK",
         *   "Task":[
         *     {
         *       "Mobile":"13800138000",
         *       "TaskID":"1",
         *       "Content":"回复内容",
         *       "ReceiveTime":"2018-12-07 15:17:26",
         *       "ExtNo":"251251"
         *     }
         *   ]
         * }
         *
         * 字段说明：
         * - ReturnStatus: Success 表示请求成功
         * - Message: 描述信息
         * - Task: 上行消息数组
         *   - Mobile: 用户手机号
         *   - TaskID: 原始发送任务ID（可用于关联）
         *   - Content: 用户回复内容
         *   - ReceiveTime: 回复时间
         *   - ExtNo: 扩展子号（如有）
         *
         * 常见错误：
         * {"ReturnStatus":"Faild","Message":"用户名或密码错误"}
         *
         * ⚠️ 注意：
         * 上行消息获取后即被清除，建议定时轮询（如每分钟一次）
         *
         * ===================================================
         */
    }

    public static String fetchReceiveMessages() {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            StringBuilder params = new StringBuilder();
            params.append("action=query")
                  .append("&rt=json")
                  .append("&userid=").append(URLEncoder.encode(USER_ID, StandardCharsets.UTF_8))
                  .append("&account=").append(URLEncoder.encode(ACCOUNT, StandardCharsets.UTF_8))
                  .append("&password=").append(URLEncoder.encode(PASSWORD, StandardCharsets.UTF_8));

            // 可选：ownExt=1 表示只返回客户自定义子号
            // .append("&ownExt=1");

            URL url = new URL(RECEIVE_URL);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);

            conn.getOutputStream().write(params.toString().getBytes(StandardCharsets.UTF_8));

            reader = new BufferedReader(new InputStreamReader(
                conn.getInputStream(), StandardCharsets.UTF_8
            ));

            StringBuilder response = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            return response.toString();

        } catch (Exception e) {
            return "{\"ReturnStatus\":\"Faild\",\"Message\":\"" + e.getMessage() + "\"}";
        } finally {
            if (conn != null) conn.disconnect();
            try { if (reader != null) reader.close(); } catch (Exception ignored) {}
        }
    }
}