import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * 状态报告接口
 * 对应文档：第四章 状态报告接口
 * 注意：相同的状态报告只能获取一次（获取后即删除）
 */
public class StatusReport {

    private static final String STATUS_URL = "http://cloud.thinksms.com/statusApi.aspx";
    private static final String USER_ID = "your_user_id";   //（登录后台->客户管理->我的信息）查询企业ID
    private static final String ACCOUNT = "your_account";   // 替换为实际值
    private static final String PASSWORD = "your_password"; // 替换为实际值

    public static void main(String[] args) {
        String result = fetchStatusReport();
        System.out.println("接口返回结果: " + result);

        /*
         * ==================== 返回值解析 ====================
         *
         * 成功示例：
         * {
         *   "ReturnStatus":"Success",
         *   "Message":"OK",
         *   "Task":[
         *     {
         *       "Mobile":"13800138000",
         *       "TaskID":"358",
         *       "Status":"10",
         *       "ReceiveTime":"2018-08-20 11:20:18",
         *       "ErrorCode":"DELIVRD",
         *       "ExtNo":""
         *     }
         *   ]
         * }
         *
         * 字段说明：
         * - ReturnStatus: Success 表示请求成功
         * - Message: 描述信息
         * - Task: 状态报告数组
         *   - Mobile: 手机号码
         *   - TaskID: 发送任务ID（与发送接口返回一致）
         *   - Status: 10=发送成功，20=发送失败
         *   - ReceiveTime: 运营商返回时间
         *   - ErrorCode: 运营商错误码（参考值）
         *   - ExtNo: 扩展子号
         *
         * 常见错误：
         * {"ReturnStatus":"Faild","Message":"用户名或密码错误"}
         *
         * ⚠️ 注意：
         * 每次获取后，状态报告会被清空，建议定时轮询（如每5分钟一次）
         *
         * ===================================================
         */
    }

    public static String fetchStatusReport() {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            StringBuilder params = new StringBuilder();
            params.append("action=query")
                  .append("&rt=json")
                  .append("&userid=").append(URLEncoder.encode(USER_ID, StandardCharsets.UTF_8))
                  .append("&account=").append(URLEncoder.encode(ACCOUNT, StandardCharsets.UTF_8))
                  .append("&password=").append(URLEncoder.encode(PASSWORD, StandardCharsets.UTF_8))
                  .append("&statusNum=100"); // 每次最多取100条，可调整

            URL url = new URL(STATUS_URL);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);

            // 发送请求体
            conn.getOutputStream().write(params.toString().getBytes(StandardCharsets.UTF_8));

            reader = new BufferedReader(new InputStreamReader(
                conn.getInputStream(), StandardCharsets.UTF_8
            ));

            StringBuilder response = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            return response.toString();

        } catch (Exception e) {
            return "{\"ReturnStatus\":\"Faild\",\"Message\":\"" + e.getMessage() + "\"}";
        } finally {
            if (conn != null) conn.disconnect();
            try { if (reader != null) reader.close(); } catch (Exception ignored) {}
        }
    }
}