﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.IO;

namespace SendSmsDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            dateTimePicker1.Value = DateTime.Now;
            dateTimePicker2.Value = DateTime.Now;
        }

        string HttpPost(string uri, string parameters)
        {
            // parameters: name1=value1&name2=value2	
            WebRequest webRequest = WebRequest.Create(uri);
            //string ProxyString = 
            //   System.Configuration.ConfigurationManager.AppSettings
            //   [GetConfigKey("proxy")];
            //webRequest.Proxy = new WebProxy (ProxyString, true);
            //Commenting out above required change to App.Config
            webRequest.ContentType = "application/x-www-form-urlencoded";
            webRequest.Method = "POST";
            byte[] bytes = Encoding.UTF8.GetBytes(parameters);//这里需要指定提交的编码
            Stream os = null;
            try
            { // send the Post
                webRequest.ContentLength = bytes.Length;   //Count bytes to send
                os = webRequest.GetRequestStream();
                os.Write(bytes, 0, bytes.Length);         //Send it
            }
            catch (WebException ex)
            {
                MessageBox.Show(ex.Message, "HttpPost: Request error",
                   MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (os != null)
                {
                    os.Close();
                }
            }
            
            try
            { // get the response
                WebResponse webResponse = webRequest.GetResponse();
                if (webResponse == null)
                { return null; }
                StreamReader sr = new StreamReader(webResponse.GetResponseStream(), System.Text.Encoding.Default);
                //上面一句需要将返回的编码进行指定，指定成默认的即可
                return sr.ReadToEnd().Trim();
            }
            catch (WebException ex)
            {
                MessageBox.Show(ex.Message, "HttpPost: Response error",
                   MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            return null;
        }

        private void button1_Click(object sender, EventArgs e)
        {//验证帐号
		//企业ID（userid），登陆后台：http://cloud.thinksms.cn 通过“客户管理”-“我的信息”查询。
            textBox3.Text = HttpPost("http://cloud.thinksms.cn/smsGBK.aspx", "userid=企业ID&account=用户账号&password=密码&action=overage");
        }

        private void button2_Click(object sender, EventArgs e)
        {//查询余额
            textBox3.Text = HttpPost("http://cloud.thinksms.cn/smsGBK.aspx", "userid=企业ID&account=用户账号&password=密码&action=overage");
        }

		private void button3_Click(object sender, EventArgs e)
		{//实时发送
			textBox3.Text = HttpPost("http://cloud.thinksms.cn/smsGBK.aspx", "action=send&userid=企业ID&account=用户账号&password=密码&content=" + textBox2.Text + "&mobile=" + textBox1.Text + "&sendtime=");
            
		} 
/*定时发送功能
        private void button3_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {//定时发送
                textBox3.Text = HttpPost("http://cloud.thinksms.cn/smsGBK.aspx", "action=send&userid=企业ID&account=用户账号&password=密码&content="
                       + textBox2.Text + "&mobile=" + textBox1.Text + "&sendtime="//大写HH表示24小时制时间
                       + dateTimePicker1.Value.ToString("yyyy-MM-dd") +" "+ dateTimePicker2.Value.ToString("HH:mm:ss"));
            }
            else
            {//即时发送
                textBox3.Text = HttpPost("http://cloud.thinksms.cn/smsGBK.aspx", "action=send&userid=企业ID&account=用户账号&password=密码&content="
                    + textBox2.Text + "&mobile=" + textBox1.Text + "&sendtime=");
            }
        } 
*/
    }
}
/*	

接入注意事项：（常见问题）
1.内容乱码						------->>>>>> 编码不同，提交入口不同。sms.aspx为utf-8提交入口，smsGBK.aspx为GBK提交入口，如两个提交入口均乱码，重新转换一下文件编码。
2.提示短信必须带【】格式签名	------->>>>>> 提交入口不正确导致乱码，系统识别不到【】签名；或发送短信时未带前缀签名；或定时短信sendtime格式错误，sendtime可为空，不能传0
3.返回错误0						------->>>>>> 定时短信sendtime格式错误，sendtime可为空或具体时间，不能传0
4.程序异常，请重试或联系客服！从字符串转换日期和/或时间时，转换失败。------->>>>>> 定时短信sendtime格式错误，sendtime可为空或具体时间，不能传0
5.其他注意事项详见接口文档说明文件。
		
*/